/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.hardware.nmos6502.commands;

import emulator.EmulatorException;
import emulator.hardware.HwByte;
import emulator.hardware.nmos6502.Cpu6502;
import emulator.hardware.nmos6502.Flags6502;
import emulator.hardware.nmos6502.commands.DEY;
import emulator.hardware.nmos6502.operands.NoOperand;
import org.junit.Assert;
import org.junit.Test;

public class DEYTest {
    @Test
    public void testDecPositive() throws EmulatorException {
        this.executeAndCheckDEY(63, 0);
    }

    @Test
    public void testDecNegative() throws EmulatorException {
        this.executeAndCheckDEY(0, 128);
    }

    @Test
    public void testDecZero() throws EmulatorException {
        this.executeAndCheckDEY(1, 2);
    }

    private void executeAndCheckDEY(int val, int expected_flags) throws EmulatorException {
        Cpu6502 cpu = new Cpu6502();
        cpu.setY(new HwByte((long)val));
        new DEY().execute(cpu, new NoOperand());
        Assert.assertEquals((Object)new HwByte((long)(val - 1)), (Object)cpu.getY());
        Assert.assertEquals((Object)new Flags6502((long)expected_flags), (Object)cpu.getFlags());
    }
}

